package book.beans;

import java.io.Serializable;
import java.util.Map;
import java.util.logging.Logger;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialViewContext;
import javax.faces.view.ViewScoped;
import javax.inject.Named;

/**
 *
 * @author Leonard
 */
@Named
@ViewScoped
public class AjaxBean implements Serializable {

    private static final Logger logger =
            Logger.getLogger(AjaxBean.class.getName());

    public void requestTypeAction() {

        FacesContext facesContext = FacesContext.getCurrentInstance();
        ExternalContext externalContext = facesContext.getExternalContext();
        Map<String, String> headers = externalContext.getRequestHeaderMap();
        logger.info(headers.toString());

        // 1. metoda określania typu żądania
        PartialViewContext partialViewContext = facesContext.getPartialViewContext();
        if (partialViewContext != null) {
            if (partialViewContext.isAjaxRequest()) {
                logger.info("TO JEST ŻĄDANIE AJAX (1. METODA OKREŚLANIA) ...");
            } else {
                logger.info("TO NIE JEST ŻĄDANIE AJAX (1. METODA OKREŚLANIA) ...");
            }
        }

        // 2. metoda określania typu żądania
        String request_type_header_FR = headers.get("Faces-Request");
        if (request_type_header_FR != null) {
            if (request_type_header_FR.equals("partial/ajax")) {
                logger.info("TO JEST ŻĄDANIE AJAX (2. METODA OKREŚLANIA) ...");
            } else {
                logger.info("TO NIE JEST ŻĄDANIE AJAX (2. METODA OKREŚLANIA) ...");
            }
        }

        // 3. metoda określania typu żądania
        String request_type_header_XRW = headers.get("X-Requested-With");
        if (request_type_header_XRW != null) {
            if (request_type_header_XRW.equals("XMLHttpRequest")) {
                logger.info("TO JEST ŻĄDANIE AJAX (3. METODA OKREŚLANIA) ...");
            } else {
                logger.info("TO NIE JEST ŻĄDANIE AJAX (3. METODA OKREŚLANIA) ...");
            }
        }
    }
}
